#ifndef _OCE_H_
#define _OCE_H_

#include "wapp_cmm.h"
struct wapp_sta;
struct wapp_conf;


#ifndef GNU_PACKED
#define GNU_PACKED  __attribute__ ((packed))
#endif /* GNU_PACKED */


typedef enum {
	OCE_SUCCESS = 0,
	OCE_INVALID_ARG,
	OCE_LOOKUP_ENTRY_NOT_FOUND,
	OCE_UNEXP,
} OCE_ERR_CODE;

typedef enum {
	OCE_CAP_UPDATE, 		/* Oce Capability */
	OCE_DELASSRSSI_UPDATE,	/* DeltaAssocRSSI */
} OCE_STA_UPDATE_CODE;

typedef enum {
	OCE_MSG_INFO_UPDATE = 0,
} OCE_MSG_TYPE;

struct oce_info {
	u8	mac_addr[MAC_ADDR_LEN];
	u8	bssid[MAC_ADDR_LEN];
	u8	OceCapIndication;
	s8	DeltaAssocRSSI;
};

typedef union GNU_PACKED _oce_msg_body{
	struct oce_info OceEvtStaInfo;
} OCE_MSG_BODY;


struct oce_msg {
	u32 ifindex;
	u8  len;
	u8 	type;
	OCE_MSG_BODY body;
};

struct oce_cfg {
	/* call back function of oce events */
	const struct oce_event_ops *event_ops;
	/* driver interface operation */
	//const struct oce_drv_ops *drv_ops;
};

int oce_init(struct oce_cfg *oce);


#endif /* #ifndef _OCE_H_ */

