 /*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2011, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	event.h

	Abstract:

	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
*/
#ifndef __EVENT_H__
#define __EVENT_H__

#include "wapp_cmm.h"
#include "hotspot.h"
#include "mbo.h"
#include "oce.h"

struct wifi_app;
struct hotspot;
struct mbo_cfg;
struct wapp_event;


struct wifi_app_event_ops {
	int (*event_get_mbo_neighbor_report)(struct wifi_app *wapp,
									   const char *ifname,
								       const char *neighbor_list_req,
									   size_t neighbor_list_len);

	void (*event_handle)(struct wifi_app *wapp, struct wapp_event *event);

	int (*event_btm_rsp)(struct wifi_app *wapp,
					 const char *ifname,
					 const u8 *peer_mac_addr,
					 const char *btm_rsp,
					 size_t btm_rsp_len);

	int (*event_btm_req)(struct wifi_app *wapp,
			const char *ifname,
			const u8 *peer_mac_addr,
			const char *btm_req,
			size_t btm_req_len);

	int (*event_btm_query)(struct wifi_app *wapp,
						   const char *ifname,
						   const u8 *peer_mac_addr,
						   const char *btm_query,
						   size_t btm_query_len);

	int (*event_anqp_req)(struct wifi_app *wapp,
							   const char *iface,
							   const u8 *peer_mac_addr,
							   char *anqp_req,
							   size_t anqp_req_len);

	int (*event_anqp_rsp)(struct wifi_app *wapp,
						  const char *ifname,
						  const u8 *peer_mac_addr,
						  int status,
						  const char *anqp_rsp,
						  size_t anqp_rsp_len);
	int (*event_offch_info)(struct wifi_app *wapp,
							u8 * buf);
#ifdef MAP_R2
	int (*event_wnm_notify)(struct wifi_app *wapp,
						 const char *iface,
						 const u8 *peer_mac_addr,
						 const char *wnm_req,
						 size_t wnm_req_len);
#endif
};

struct hotspot_event_ops {
	int (*event_test)(struct wifi_app *wapp);

	int (*event_hs_onoff)(struct wifi_app *wapp,
						 const char *ifname,
						 int enable);

	int (*event_proxy_arp)(struct wifi_app *wapp,
						   const int ifindex,
						   u8 ip_type,
						   u8 from_ds,
						   const char *source_mac_addr,
						   const char *source_ip_addr,
						   const char *target_mac_addr,
						   const char *target_ip_addr,
						   unsigned char IsDAD);

	int (*event_ap_reload)(struct wifi_app *wapp,
						   const char *ifname);

	int (*event_get_location_IE)(struct wifi_app *wapp,
						   char *location);

};


struct mbo_event_ops {
	int (*get_neighbor_report)(struct hotspot *hs,
						   char *pMboMsg);
	int (*sta_update)(struct wifi_app *wapp, char *pMboMsg, u8 msg_type);
};

struct oce_event_ops {
	int (*sta_update)(struct wifi_app *wapp, char *pOcoMsg, u8 msg_type);
};


enum {
	HS_ON_OFF_BASE,
	HS_AP_RELOAD,
};

enum {
	EVENT_TRIGGER_OFF,
	EVENT_TRIGGER_ON,
};

#endif /* __EVENT_H__ */
