/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2011, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	driver.h

	Abstract:

	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
*/

#ifndef __DRIVER_H__
#define __DRIVER_H__

#include "hotspot.h"
#include "wapp_cmm.h"

struct hotspot;
struct wifi_app;
struct wapp_req;

struct wapp_drv_ops {
	void * (*drv_inf_init)(struct wifi_app *wapp, const int opmode, const int drv_mode);
	int (*drv_inf_exit)(struct wifi_app *wapp);
	int (*drv_wifi_version)(void *drv_dta, const char *ifname,
							char *ver, size_t *len);
	int (*drv_wapp_version_check)(void *drv_dta, const char *ifname);
	
	int (*drv_wapp_req) (void *drv_data, const char *ifname, struct wapp_req *req);
	int (*drv_send_btm_req)(void *drv_data, const char *ifname,
							const u8 *peer_sta_addr, const char *btm_req,
							size_t btm_req_len);
	int (*drv_send_btm_query)(void *drv_data, const char *ifname,
							  const char *peer_sta_addr, const char *btm_query,
							  size_t btm_query_len);
	int (*drv_send_btm_rsp)(void *drv_data, const char *ifname,
							const u8 *peer_sta_addr, const char *btm_rsp,
							size_t btm_rsp_len);
	int (*drv_send_reduced_nr_list)(void *drv_data, const char *ifname,
							const char *reduced_nr_list,
							size_t reduced_nr_list_len);
	int (*drv_wapp_param_setting)(void *drv_data, const char *ifname, u32 param, u32 value);
	int (*drv_send_anqp_req)(void *drv_data, const char *ifname,
							 const char *peer_sta_addr,const char *anqp_req,
							 size_t anqp_req_len);
	int (*drv_send_anqp_rsp)(void *drv_data, const char *ifname,
							 const u8 *peer_sta_addr,const char *anqp_rsp,
							 size_t anqp_rsp_len);
	int (*drv_set_interworking)(void *drv_data, const char *ifname, char *enable, size_t len);
	int (*drv_send_wnm_notify_req)(void *drv_data, const char *ifname,
							const char *peer_sta_addr, const char *btm_req, size_t btm_req_len, int type);
	int (*drv_set_ie)(void *drv_data, const char *ifname, char *ie,
					  size_t ie_len);
	int (*drv_wps_pbc_trigger)(void *drv_dta, const char *ifname,
							char *ver, size_t *len);
#ifdef MAP_R2
	int (*drv_ch_scan_req)(void *drv_dta, const char *ifname,
							const char *ch_scan_req, size_t len);
#ifdef DFS_CAC_R2
	int (*drv_cac_req)(void *drv_data, const char *ifname, u32 param, u32 value);
#endif
#endif
	int (*drv_get_misc_cap)(void *drv_data, const char *ifname, char *buf, 
								  size_t *buf_len);
	int (*drv_get_ht_cap)(void *drv_data, const char *ifname, char *buf, 
								  size_t *buf_len);
	int (*drv_get_vht_cap)(void *drv_data, const char *ifname, char *buf, 
								  size_t *buf_len);
	int (*drv_get_he_cap)(void *drv_data, const char *ifname, char *buf, 
								  size_t *buf_len);
	int (*drv_get_chan_list)(void *drv_data, const char *ifname, char *buf, 
								  size_t *buf_len);
	int (*drv_get_nop_channels)(void *drv_data, const char *ifname, char *buf, 
								  size_t *buf_len);
	int (*drv_get_op_class)(void *drv_data, const char *ifname, char *buf, 
								  size_t *buf_len);
	int (*drv_get_bss_info)(void *drv_data, const char *ifname, char *buf, 
								  size_t *buf_len);
	int (*drv_get_ap_metrics)(void *drv_data, const char *ifname, char *buf, 
								  size_t *buf_len);
	int (*drv_off_ch_scan_req)(void *drv_dta, const char *ifname,
							const char *ch_scan_req, size_t len);
	int (*drv_get_chip_id)(void *drv_data, const char *ifname, char *buf, 
								  size_t *buf_len);
};

struct hotspot_drv_ops {
	int (*drv_test)(void *drv_data, const char *ifname);
	
	int (*drv_hotspot_onoff)(void *drv_data, const char *ifname,
                             int enable, int event_trigger, int event_type);
	
	int (*drv_hs_param_setting)(void *drv_data, const char *ifname, u32 param, u32 value);

	int (*drv_ipv4_proxy_arp_list)(void *drv_data, const char *ifname,
							  	   char *proxy_arp_list, size_t *proxy_arp_list_len);
	
	int (*drv_ipv6_proxy_arp_list)(void *drv_data, const char *ifname,
							  	   char *proxy_arp_list, size_t *proxy_arp_list_len);
	int (*drv_validate_security_type)(void *drv_data, const char *ifname);
	int (*drv_reset_resource)(void *drv_data, const char *ifname);
	int (*drv_get_bssid)(void *drv_data, const char *ifname, char *bssid, size_t *bssid_len);
	int (*drv_get_osu_ssid)(void *drv_data, const char *ifname, char *ssid, size_t *ssid_len);
	int (*drv_set_osu_asan)(void *drv_data, const char *ifname, char *enable, size_t len);
	
	int (*drv_send_qosmap_configure)(void *drv_data, const char *ifname,
							const char *peer_sta_addr, const char *qosmap, size_t qosmap_len);
	int (*drv_set_bss_load)(void *drv_data, const char *ifname, char *buf, size_t len);
	
};

struct mbo_drv_ops {
	int (*drv_mbo_param_setting)(void *drv_data, const char *ifname, u32 param, u32 value);
};

#endif /* __DRIVER_H__ */
