/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2011, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	main.c

	Abstract:

	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include "wapp_cmm.h"


/*
========================================================================
IAPP
========================================================================
*/

#include "rt_config.h"
#include "rtmpiapp.h"
#include "iappdefs.h"

VOID IAPP_Usage(
	VOID)
{
	printf("\tUSAGE:\t\tralinkiappd <-e eth_if_name> <-w wireless_if_name>\n");
	printf("\t\t\t\t<-k security_key> <-d debug level>\n");
	printf("\tDefault:\tralinkiappd -e br0 -w ra0 -k 12345678 -d 3\n");
}

/*
========================================================================
HOTSPOT
========================================================================
*/

#include "hotspot.h"
extern struct hotspot_event_ops hs_event_ops;
extern void wapp_iface_deinit(struct wifi_app *wapp);

int hs_usage()
{

	DBGPRINT(RT_DEBUG_OFF, "hotspot [-f <hotspot configuration file>] [-m <hotspot mode>] [-i <hotspot ipc type>] [-d <debug level>] [-I <ineterface name>]\n");
	DBGPRINT(RT_DEBUG_OFF, "-f <hotspot configuration file>\n");
	DBGPRINT(RT_DEBUG_OFF, "-m <hotspot mode> (OPMODE_STA, OPMODE_AP)\n");
	DBGPRINT(RT_DEBUG_OFF, "-i <hotspot ipc type> (RA_WEXT, RA_NETLINK)\n");
	DBGPRINT(RT_DEBUG_OFF, "-d <hotspot debug level>\n");
	DBGPRINT(RT_DEBUG_OFF, "-h help\n");
	return 0;
}

/*
========================================================================
MBO
========================================================================
*/
#ifdef MAP_SUPPORT
int process_options(int argc, char *argv[], char *filename,
					int *opmode, int *drv_mode, int *debug_level, int *version, char *iface
					,char *map_cfg, char *map_user_cfg
					, RTMP_IAPP *pCtrlBK
					)
#else
int process_options(int argc, char *argv[], char *filename,
					int *opmode, int *drv_mode, int *debug_level, int *version, char *iface
					,RTMP_IAPP *pCtrlBK
					)
#endif
{
	int c;
	char *cvalue = NULL;
	int i = 0;

	/* IAPP init */
	strcpy(pCtrlBK->IfNameEth, FT_KDP_DEFAULT_IF_ETH);
	strcpy(pCtrlBK->IfNameWlan, FT_KDP_DEFAULT_IF_WLAN);
	strcpy(pCtrlBK->IfNameWlanIoctl[0], FT_KDP_DEFAULT_IF_WLAN_IOCTL);

	strcpy(pCtrlBK->CommonKey, FT_KDP_DEFAULT_PTK);


	opterr = 0;

	while ((c = getopt(argc, argv, "m:f:i:d:v:e:w:k:c:F:u:")) != -1) {
		switch (c) {
		case 'd':
			cvalue = optarg;
			if (os_strcmp(cvalue, "0") == 0)
				*debug_level = RT_DEBUG_OFF;
			else if (os_strcmp(cvalue, "1") == 0)
				*debug_level = RT_DEBUG_ERROR;
			else if (os_strcmp(cvalue, "2") == 0)
				*debug_level = RT_DEBUG_WARN;
			else if (os_strcmp(cvalue, "3") == 0)
				*debug_level = RT_DEBUG_TRACE;
			else if (os_strcmp(cvalue, "4") == 0)
				*debug_level = RT_DEBUG_INFO;
			else {
				DBGPRINT(RT_DEBUG_ERROR, "-d option does not have this debug_level %s\n", cvalue);
				return - 1;
			}
			break;
		case 'f':
			cvalue = optarg;
			os_strcpy(filename, cvalue);
			break;
		case 'm':
			cvalue = optarg;
			if (os_strcmp(cvalue, "OPMODE_STA") == 0)
				*opmode = OPMODE_STA;
			else if (os_strcmp(cvalue, "OPMODE_AP") == 0)
				*opmode = OPMODE_AP;
			else {
				DBGPRINT(RT_DEBUG_ERROR, "-m option does not have this mode %s\n", cvalue);
				return -1;
			}
			break;
		case 'i':
			cvalue = optarg;
			if (os_strcmp(cvalue, "RA_WEXT") == 0)
				*drv_mode = RA_WEXT;
			else if (os_strcmp(cvalue, "RA_NETLINK") == 0)
				*drv_mode = RA_NETLINK;
			else {
				DBGPRINT(RT_DEBUG_OFF, "-i option does not have this type %s\n", cvalue);
				return -1;
			}
			break;
		case 'v':
			cvalue = optarg;
           	*version = atoi(cvalue);
 			break;
		case 'h':
			cvalue = optarg;
			hs_usage();
			IAPP_Usage();
			break;
		case 'e':
			cvalue = optarg;
			os_strcpy(pCtrlBK->IfNameEth, cvalue);
			break;
		case 'w':
			cvalue = optarg;
			os_strcpy(pCtrlBK->IfNameWlan, cvalue);
			break;
		case 'k':
			cvalue = optarg;
			if (strlen(cvalue) > IAPP_ENCRYPT_KEY_MAX_SIZE)
			{
				cvalue[IAPP_ENCRYPT_KEY_MAX_SIZE] = 0x00;

				DBGPRINT(RT_DEBUG_TRACE, "iapp> key length can not be larger than %d!",
						IAPP_ENCRYPT_KEY_MAX_SIZE);
			}
			strcpy(pCtrlBK->CommonKey, cvalue);
			break;
		case 'c': //original IAPP -wi : wlan ioctl interface
			cvalue = optarg;
			strcpy(pCtrlBK->IfNameWlanIoctl[pCtrlBK->IfNameWlanCount++], cvalue);
			break;
		case '?':
			if (optopt == 'f') {
				DBGPRINT(RT_DEBUG_OFF, "Option -%c requires an argument\n", optopt);
			} else if (optopt == 'm') {
				DBGPRINT(RT_DEBUG_OFF, "Option -%c requires an argument\n", optopt);
			} else if (optopt == 'd') {
				DBGPRINT(RT_DEBUG_OFF, "Option -%c requires an argument\n", optopt);
			} else if (optopt == 'i') {
				DBGPRINT(RT_DEBUG_OFF, "Option -%c requires an argument\n", optopt);
			} else if (isprint(optopt)) {
				DBGPRINT(RT_DEBUG_OFF, "Unknow options -%c\n", optopt);
			} else {

			}
			return -1;
			break;
#ifdef MAP_SUPPORT
		case 'F':
			cvalue = optarg;
			if (strlen(cvalue) != 0) {
				strcpy(map_cfg, cvalue);
			}
			break;
		case 'u':
			cvalue = optarg;
			if (strlen(cvalue) != 0) {
				strcpy(map_user_cfg, cvalue);
			}
			break;
#endif
		}
	}

	if (strlen(iface) == 0)
	{
		os_strcpy(iface, DEFAULT_IFNAME);
		DBGPRINT(RT_DEBUG_OFF, "Default interface: %s\n", iface);
	} else {
		DBGPRINT(RT_DEBUG_OFF, "Interface: %s\n", iface);
	}

//label_exit:
	if (pCtrlBK->IfNameWlanCount == 0)
		pCtrlBK->IfNameWlanCount = 1;
	DBGPRINT(RT_DEBUG_TRACE, "iapp> -e=%s, -w=%s",
			pCtrlBK->IfNameEth, pCtrlBK->IfNameWlan);

	for (i = 0; i < pCtrlBK->IfNameWlanCount; i++) {
		DBGPRINT(RT_DEBUG_TRACE, ", -wi=%s",
			pCtrlBK->IfNameWlanIoctl[i]);
	}
	DBGPRINT(RT_DEBUG_TRACE, ", IfNameWlanCount = %d\n", pCtrlBK->IfNameWlanCount);
	return 0;

}

int main(int argc, char *argv[])
{
	int ret;
	int opmode;
	int drv_mode;
	int debug_level;
	int version = 2;
	char filename[256] = {0};
	struct wifi_app wapp_cfg;
	struct hotspot hs;
	struct mbo_cfg mbo;
	struct oce_cfg oce;
#ifdef MAP_SUPPORT
	struct map_info map;
	char value[10] = {0};
	char map_cfg[128]= {0};
	char map_user_cfg[128]= {0};
#endif
	struct _RTMP_IAPP IAPP_Ctrl_Block;
	struct wifi_app *wapp = &wapp_cfg;
	pid_t child_pid_hs,child_pid_iapp;

	/* default setting */
	opmode = OPMODE_AP;
	drv_mode = RA_WEXT;

	memset(wapp,0,sizeof(struct wifi_app));
	memset(&hs,0,sizeof(struct hotspot));
	memset(&mbo,0,sizeof(struct mbo_cfg));
	memset(&oce,0,sizeof(struct oce_cfg));
#ifdef MAP_SUPPORT
    memset(&map, 0, sizeof(struct map_info));
#endif
	memset(&IAPP_Ctrl_Block,0,sizeof(struct _RTMP_IAPP));

#ifdef MAP_SUPPORT
	ret = process_options(argc, argv, filename, &opmode, &drv_mode, &debug_level, &version, &wapp_cfg.iface[0], map_cfg, map_user_cfg, &IAPP_Ctrl_Block);
#else
	ret = process_options(argc, argv, filename, &opmode, &drv_mode, &debug_level, &version, &wapp_cfg.iface[0],&IAPP_Ctrl_Block);

#endif

	if(ret){
		hs_usage();
		return -1;
	}

	RTDebugLevel = debug_level;

	ret = wapp_cmm_init(wapp,drv_mode,opmode,version,&hs,&mbo, &oce, &map, &IAPP_Ctrl_Block);
	if (ret)
		goto error;

#ifdef MAP_SUPPORT
	if(strlen(map_cfg) == 0)
	{
		strcpy(wapp->map->map_cfg, "/etc/map/mapd_cfg");
	}
	else
	{
		strcpy(wapp->map->map_cfg, map_cfg);
	}

	if(strlen(map_user_cfg) == 0)
	{
		strcpy(wapp->map->map_user_cfg, "/etc/map/mapd_user.cfg");
	}
	else
	{
		strcpy(wapp->map->map_user_cfg, map_user_cfg);
	}
#endif

	DBGPRINT(RT_DEBUG_OFF, "Map cfg file: %s Map user cfg: %s\n", wapp->map->map_cfg, wapp->map->map_user_cfg);

#ifdef MAP_SUPPORT
		dl_list_init(&wapp->air_monitor_query_list);
		dl_list_init(&wapp->sta_mntr_list);
#endif
	setsid();
	child_pid_hs = fork();
	if (child_pid_hs == 0) {
		DBGPRINT(RT_DEBUG_ERROR, "Initialize socket\n");
		ret = wapp_socket_and_ctrl_inf_init(wapp,drv_mode,opmode);
		ret += wapp_get_wireless_interfaces(wapp);
#ifdef MAP_SUPPORT
	get_map_parameters(wapp->map, "Enable_WPS_toggle_5GL_5GH", value, NON_DRIVER_PARAM, sizeof(value));
	if (!strcmp(value,"1"))
		wapp->map->enable_wps_toggle_5GL_5GH = 1;
	else
		wapp->map->enable_wps_toggle_5GL_5GH = 0;
	get_map_parameters(wapp->map, "MAP_QuickChChange", value, NON_DRIVER_PARAM, sizeof(value));
	if (!strcmp(value,"1"))
		wapp->map->quick_ch_change = 1;
	else
		wapp->map->quick_ch_change = 0;
#ifdef MAP_R2
	get_map_parameters(wapp->map, "MetricRepIntv", value, NON_DRIVER_PARAM, sizeof(value));
	wapp->map->metric_rep_intv = atoi(value);
#endif
		/*if MAP enable, create ARP socket for br & wireless interface*/
		get_map_parameters(wapp->map, "MapMode", value, DRIVER_PARAM, sizeof(value));
                if (!strcmp(value,"1"))
			ret += wapp_create_arp_socket(wapp);
#endif
		if (ret)
			goto error;

		if (os_strlen(filename) == 0) {
				DBGPRINT(RT_DEBUG_TRACE, "Use default configuration file /etc/wapp_ap.conf");
				os_strcpy(filename, WAPP_CONF_PATH"/wapp_ap.conf");
		}

		ret = wapp_init_all_config(wapp, filename);

		if (ret) {
			DBGPRINT(RT_DEBUG_OFF, "Initial hotspot configuration file(%s) fail\n", filename);
			goto error0;
		}

		ret = hotspot_set_ap_ifaces_all_ies(wapp);

		if (ret)
			goto error1;

		/* Enable hotspot feature for all interfaces */
		ret = hotspot_onoff_all(wapp, 1);

//		if (ret)
//			goto error2;

		hotspot_run(wapp);

		/* Disable hotspot feature for all interfaces */
		hotspot_onoff_all(wapp, 0);
	}
	else{
		child_pid_iapp = fork();
		if (child_pid_iapp == 0) {
			DBGPRINT(RT_DEBUG_OFF, "Initialize IAPP\n");
#ifdef IAPP_OS_LINUX
			IAPP_Task((VOID *)wapp->IAPP_Ctrl_Block);
#endif /* IAPP_OS_LINUX */
		}
		else{
			return 0;
		}

		return 0;
	}

// TODO: WAPP deinit

//error2:
//	hotspot_reset_all_ap_resource(wapp);
error1:
	wapp_deinit_all_config(wapp);
error0:
	hotspot_deinit(wapp);
#ifdef MAP_SUPPORT
	map_bss_table_release(wapp->map);
	wapp_iface_deinit(wapp);
#endif
error:
	exit(-1);
}

