/*
 ***************************************************************************
 * MediaTek Inc.
 *
 * All rights reserved. source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of MediaTek. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of MediaTek, Inc. is obtained.
 ***************************************************************************

	Module Name:
	txpwr.h
*/

#ifndef __TXPWR_H__
#define __TXPWR_H__

/*******************************************************************************
 *	INCLUDED FILES
 ******************************************************************************/
#include "eeprom/mt_tx_pwr.h"

/*******************************************************************************
 *	DEFINITIONS
 ******************************************************************************/

/* Debug log color */
#define KNRM  "\x1B[0m"
#define KRED  "\x1B[31m"
#define KGRN  "\x1B[32m"
#define KYEL  "\x1B[33m"
#define KBLU  "\x1B[34m"
#define KMAG  "\x1B[35m"
#define KCYN  "\x1B[36m"
#define KWHT  "\x1B[37m"

/** M7615/MT7622/MT7626/MT7663 **/
#define SINGLE_SKU_PARSE_TABLE_CCK_LENGTH_V0	4
#define SINGLE_SKU_PARSE_TABLE_OFDM_LENGTH_V0	8
#define SINGLE_SKU_PARSE_TABLE_HTVHT20_LENGTH_V0 10
/* VHT40 MCS 0 ~ 9 and HT40 MCS32*/
#define SINGLE_SKU_PARSE_TABLE_HTVHT40_LENGTH_V0 11
#define SINGLE_SKU_PARSE_TABLE_VHT80_LENGTH_V0	10
#define SINGLE_SKU_PARSE_TABLE_VHT160_LENGTH_V0	10

#define SINGLE_SKU_FILL_TABLE_CCK_LENGTH_V0		4
#define SINGLE_SKU_FILL_TABLE_OFDM_LENGTH_V0	8
#define SINGLE_SKU_FILL_TABLE_HT20_LENGTH_V0	8
/* VHT40 MCS 0 ~ 9 and HT40 MCS32*/
#define SINGLE_SKU_FILL_TABLE_HT40_LENGTH_V0	9
#define SINGLE_SKU_FILL_TABLE_VHT20_LENGTH_V0	10
#define SINGLE_SKU_FILL_TABLE_VHT40_LENGTH_V0	10
#define SINGLE_SKU_FILL_TABLE_VHT80_LENGTH_V0	10
#define SINGLE_SKU_FILL_TABLE_VHT160_LENGTH_V0	10

/* CCK(1) + OFDM(1) + BW20/40/80/160(4) */
#define SINGLE_SKU_TYPE_PARSE_NUM_V0			6
/* CCK(4) + OFDM(8) + BW20/40/80/160(10+11+10+10) */
#define SINGLE_SKU_PARAM_PARSE_NUM_V0			53
/* CCK(1) + OFDM(1) + HT20/40(2) + VHT20/40/80/160(4) */
#define SINGLE_SKU_TYPE_NUM_V0					8
/* CCK(4) + OFDM(8) + HT20/40(8+9) + VHT20/40/80/160(10+10+10+10) */
#define SINGLE_SKU_PARAM_NUM_V0					69

#define BACKOFF_TABLE_BF_OFF_CCK_LENGTH_V0		4
#define BACKOFF_TABLE_BF_OFF_OFDM_LENGTH_V0		4
#define BACKOFF_TABLE_BF_ON_OFDM_LENGTH_V0		3
#define BACKOFF_TABLE_BF_OFF_HT20_LENGTH_V0		10
#define BACKOFF_TABLE_BF_ON_HT20_LENGTH_V0		10
#define BACKOFF_TABLE_BF_OFF_HT40_LENGTH_V0		10
#define BACKOFF_TABLE_BF_ON_HT40_LENGTH_V0		10
#define BACKOFF_TABLE_BF_OFF_VHT20_LENGTH_V0	10
#define BACKOFF_TABLE_BF_ON_VHT20_LENGTH_V0		10
#define BACKOFF_TABLE_BF_OFF_VHT40_LENGTH_V0	10
#define BACKOFF_TABLE_BF_ON_VHT40_LENGTH_V0		10
#define BACKOFF_TABLE_BF_OFF_VHT80_LENGTH_V0	10
#define BACKOFF_TABLE_BF_ON_VHT80_LENGTH_V0		10
#define BACKOFF_TABLE_BF_OFF_VHT160_LENGTH_V0	10
#define BACKOFF_TABLE_BF_ON_VHT160_LENGTH_V0	10

/* CCK(0+1) + OFDM(1+1) + VHT20/40/80/160(1+1, 1+1, 1+1, 1+1) */
#define BACKOFF_TYPE_PARSE_NUM_V0				11
/* CCK(0+4) + OFDM(3+4) VHT20/40/80/160(10+10, 10+10, 10+10, 10+10) */
#define BACKOFF_PARAM_PARSE_NUM_V0				91
/* CCK(0+1) + OFDM(1+1) + HT20/40(1+1, 1+1) + VHT20/40/80/160(1+1, 1+1, 1+1, 1+1) */
#define BACKOFF_TYPE_NUM_V0						15
/* CCK(0+4) + OFDM(3+4) + HT20/40(10+10, 10+10) + VHT20/40/80/160(10+10, 10+10, 10+10, 10+10) */
#define BACKOFF_PARAM_NUM_V0					131

/* MT7915/AXE */
#define SINGLE_SKU_PARSE_TABLE_CCK_LENGTH_V1	4
#define SINGLE_SKU_PARSE_TABLE_OFDM_LENGTH_V1	8
/* VHT20 MCS10/MCS11 */
#define SINGLE_SKU_PARSE_TABLE_HTVHT20_LENGTH_V1	12
/* VHT40 MCS 0 ~ 9 and HT40 MCS32*/
#define SINGLE_SKU_PARSE_TABLE_HTVHT40_LENGTH_V1	13
/* VHT80 MCS10/MCS11 */
#define SINGLE_SKU_PARSE_TABLE_VHT80_LENGTH_V1	12
/* VHT160 MCS10/MCS11 */
#define SINGLE_SKU_PARSE_TABLE_VHT160_LENGTH_V1	12
#define SINGLE_SKU_PARSE_TABLE_RU26_LENGTH_V1	12
#define SINGLE_SKU_PARSE_TABLE_RU52_LENGTH_V1	12
#define SINGLE_SKU_PARSE_TABLE_RU106_LENGTH_V1	12
#define SINGLE_SKU_PARSE_TABLE_RU242_LENGTH_V1	12
#define SINGLE_SKU_PARSE_TABLE_RU484_LENGTH_V1	12
#define SINGLE_SKU_PARSE_TABLE_RU996_LENGTH_V1	12
#define SINGLE_SKU_PARSE_TABLE_RU996X2_LENGTH_V1	12

#define SINGLE_SKU_FILL_TABLE_CCK_LENGTH_V1		4
#define SINGLE_SKU_FILL_TABLE_OFDM_LENGTH_V1	8
#define SINGLE_SKU_FILL_TABLE_HT20_LENGTH_V1	8
/* VHT40 MCS 0 ~ 9 and HT40 MCS32*/
#define SINGLE_SKU_FILL_TABLE_HT40_LENGTH_V1	9
#define SINGLE_SKU_FILL_TABLE_VHT20_LENGTH_V1	12
#define SINGLE_SKU_FILL_TABLE_VHT40_LENGTH_V1	12
#define SINGLE_SKU_FILL_TABLE_VHT80_LENGTH_V1	12
#define SINGLE_SKU_FILL_TABLE_VHT160_LENGTH_V1	12
#define SINGLE_SKU_FILL_TABLE_RU26_LENGTH_V1	12
#define SINGLE_SKU_FILL_TABLE_RU52_LENGTH_V1	12
#define SINGLE_SKU_FILL_TABLE_RU106_LENGTH_V1	12
#define SINGLE_SKU_FILL_TABLE_RU242_LENGTH_V1	12
#define SINGLE_SKU_FILL_TABLE_RU484_LENGTH_V1	12
#define SINGLE_SKU_FILL_TABLE_RU996_LENGTH_V1	12
#define SINGLE_SKU_FILL_TABLE_RU996X2_LENGTH_V1	12

/* CCK(1) + OFDM(1) + BW20/40/80/160(4) + RU26/52/106/242/484/996/996X2(7)*/
#define SINGLE_SKU_TYPE_PARSE_NUM_V1			13
/* CCK(4) + OFDM(8) + BW20/40/80/160(12+13+12+12) + RU26/52/106/242/484/996/996X2(12+12+12+12+12+12+12)*/
#define SINGLE_SKU_PARAM_PARSE_NUM_V1			145
/* CCK(1) + OFDM(1) + HT20/40(2) + VHT20/40/80/160(4) + RU26/52/106/242/484/996/996X2(7)*/
#define SINGLE_SKU_TYPE_NUM_V1					15
/* CCK(4) + OFDM(8) + HT20/40(8+9) + VHT20/40/80/160(12+12+12+12) + RU26/52/106/242/484/996/996X2(12+12+12+12+12+12+12)*/
#define SINGLE_SKU_PARAM_NUM_V1					161

#define BACKOFF_TABLE_BF_OFF_CCK_LENGTH_V1		4
#define BACKOFF_TABLE_BF_OFF_OFDM_LENGTH_V1		4
#define BACKOFF_TABLE_BF_ON_OFDM_LENGTH_V1		3
#define BACKOFF_TABLE_BF_OFF_HT20_LENGTH_V1		10
#define BACKOFF_TABLE_BF_ON_HT20_LENGTH_V1		9
#define BACKOFF_TABLE_BF_OFF_HT40_LENGTH_V1		10
#define BACKOFF_TABLE_BF_ON_HT40_LENGTH_V1		9
#define BACKOFF_TABLE_BF_OFF_VHT20_LENGTH_V1	10
#define BACKOFF_TABLE_BF_ON_VHT20_LENGTH_V1		9
#define BACKOFF_TABLE_BF_OFF_VHT40_LENGTH_V1	10
#define BACKOFF_TABLE_BF_ON_VHT40_LENGTH_V1		9
#define BACKOFF_TABLE_BF_OFF_VHT80_LENGTH_V1	10
#define BACKOFF_TABLE_BF_ON_VHT80_LENGTH_V1		9
#define BACKOFF_TABLE_BF_OFF_VHT160_LENGTH_V1	10
#define BACKOFF_TABLE_BF_ON_VHT160_LENGTH_V1	9
#define BACKOFF_TABLE_BF_OFF_RU26_LENGTH_V1		10
#define BACKOFF_TABLE_BF_ON_RU26_LENGTH_V1		10
#define BACKOFF_TABLE_BF_OFF_RU52_LENGTH_V1		10
#define BACKOFF_TABLE_BF_ON_RU52_LENGTH_V1		10
#define BACKOFF_TABLE_BF_OFF_RU106_LENGTH_V1	10
#define BACKOFF_TABLE_BF_ON_RU106_LENGTH_V1		10

/* CCK(0+1) + OFDM(1+1) + VHT20/40/80/160(1+1, 1+1, 1+1, 1+1) + RU26/52/106(1+1, 1+1, 1+1)*/
#define BACKOFF_TYPE_PARSE_NUM_V1				17
/* CCK(0+4) + OFDM(3+4) VHT20/40/80/160(9+10, 9+10, 9+10, 9+10) + RU26/52/106(10+10, 10+10, 10+10)*/
#define BACKOFF_PARAM_PARSE_NUM_V1				147
/* CCK(0+1) + OFDM(1+1) + HT20/40(1+1, 1+1) + VHT20/40/80/160(1+1, 1+1, 1+1, 1+1) + RU26/52/106(1+1, 1+1, 1+1)*/
#define BACKOFF_TYPE_NUM_V1						21
/* CCK(0+4) + OFDM(3+4) + HT20/40(9+10, 9+10) + VHT20/40/80/160(9+10, 9+10, 9+10, 9+10) + RU26/52/106(10+10, 10+10, 10+10)*/
#define BACKOFF_PARAM_NUM_V1					185

/*******************************************************************************
 *	MACRO
 ******************************************************************************/


/*******************************************************************************
 *	TYPES
 ******************************************************************************/

/** union for Sku Table */
typedef union _UNION_SKU_TABLE_TYPE {
	INT8 i1PwrLimitV0[SINGLE_SKU_PARAM_NUM_V0];
	INT8 i1PwrLimitV1[SINGLE_SKU_PARAM_NUM_V1];
} UNION_SKU_TABLE_TYPE, *P_UNION_SKU_TABLE_TYPE;

/** union for Backoff Table */
typedef union _UNION_BACKOFF_TABLE_TYPE {
	INT8 i1PwrLimitV0[BACKOFF_PARAM_NUM_V0];
	INT8 i1PwrLimitV1[BACKOFF_PARAM_NUM_V1];
} UNION_BACKOFF_TABLE_TYPE, *P_UNION_BACKOFF_TABLE_TYPE;

/** union */
typedef union _UNION_POWER_LIMIT_TABLE {
	UNION_SKU_TABLE_TYPE rSkuTbl;
	UNION_BACKOFF_TABLE_TYPE rBackoffTbl;
} UNION_POWER_LIMIT_TABLE, *P_UNION_POWER_LIMIT_TABLE;

typedef struct _CMD_POWER_LIMIT_TABLE_CTRL_T {
    UINT8  u1PowerCtrlFormatId;
    UINT8  u1PwrLimitType;
    UINT8  u1BandIdx;
    UNION_POWER_LIMIT_TABLE  uPwrLimitTbl;
} CMD_POWER_LIMIT_TABLE_CTRL_T, *P_CMD_POWER_LIMIT_TABLE_CTRL_T;

typedef struct _CMD_POWER_BOOST_TABLE_CTRL_T {
	UINT8    ucPowerCtrlFormatId;
	UINT8    ucBandIdx;
	CHAR     cPwrUpCat;
	CHAR     cPwrUpValue[POWER_UP_CATEGORY_RATE_NUM];
	UINT8    ucReserved;
} CMD_POWER_BOOST_TABLE_CTRL_T, *P_CMD_POWER_BOOST_TABLE_CTRL_T;

typedef enum _TX_POWER_TYPE {
	TX_POWER_TYPE_V0 = 0,
	TX_POWER_TYPE_V1,
	TX_POWER_TYPE_NUM
} TX_POWER_TYPE, *P_TX_POWER_TYPE;

/* Txpower V0 struct */
/* TX Power Boost Feature */
typedef enum _POWER_BOOST_TABLE_CATEGORY_V0 {
	POWER_UP_CATE_V0_CCK = 0,
	POWER_UP_CATE_V0_OFDM,
	POWER_UP_CATE_V0_HT20,
	POWER_UP_CATE_V0_HT40,
	POWER_UP_CATE_V0_VHT20,
	POWER_UP_CATE_V0_VHT40,
	POWER_UP_CATE_V0_VHT80,
	POWER_UP_CATE_V0_VHT160,
	POWER_UP_CATE_V0_NUM
} POWER_BOOST_TABLE_CATEGORY_V0, *P_POWER_BOOST_TABLE_CATEGORY_V0;

#ifdef TX_POWER_CONTROL_SUPPORT
typedef struct {
	CHAR cPowerUpCck[SINGLE_SKU_FILL_TABLE_CCK_LENGTH_V0];
	CHAR cPowerUpOfdm[SINGLE_SKU_FILL_TABLE_OFDM_LENGTH_V0];
	CHAR cPowerUpHt20[SINGLE_SKU_FILL_TABLE_HT20_LENGTH_V0];
	CHAR cPowerUpHt40[SINGLE_SKU_FILL_TABLE_HT40_LENGTH_V0];
	CHAR cPowerUpVht20[SINGLE_SKU_FILL_TABLE_VHT20_LENGTH_V0];
	CHAR cPowerUpVht40[SINGLE_SKU_FILL_TABLE_VHT40_LENGTH_V0];
	CHAR cPowerUpVht80[SINGLE_SKU_FILL_TABLE_VHT80_LENGTH_V0];
	CHAR cPowerUpVht160[SINGLE_SKU_FILL_TABLE_VHT160_LENGTH_V0];
} POWER_BOOST_PARA_V0, *PPOWER_BOOST_PARA_V0;
#endif /* TX_POWER_CONTROL_SUPPORT */

/* Txpower V1 struct */
/* TX Power Boost feature */
typedef enum _POWER_BOOST_TABLE_CATEGORY_V1 {
	POWER_UP_CATE_V1_CCK = 0,
	POWER_UP_CATE_V1_OFDM,
	POWER_UP_CATE_V1_HT20,
	POWER_UP_CATE_V1_HT40,
	POWER_UP_CATE_V1_VHT20,
	POWER_UP_CATE_V1_VHT40,
	POWER_UP_CATE_V1_VHT80,
	POWER_UP_CATE_V1_VHT160,
	POWER_UP_CATE_V1_RU26,
	POWER_UP_CATE_V1_RU52,
	POWER_UP_CATE_V1_RU106,
	POWER_UP_CATE_V1_RU242,
	POWER_UP_CATE_V1_RU484,
	POWER_UP_CATE_V1_RU996,
	POWER_UP_CATE_V1_RU996X2,
	POWER_UP_CATE_V1_NUM
} POWER_BOOST_TABLE_CATEGORY_V1, *P_POWER_BOOST_TABLE_CATEGORY_V1;

#ifdef TX_POWER_CONTROL_SUPPORT
typedef struct {
	CHAR cPowerUpCck[SINGLE_SKU_FILL_TABLE_CCK_LENGTH_V1];
	CHAR cPowerUpOfdm[SINGLE_SKU_FILL_TABLE_OFDM_LENGTH_V1];
	CHAR cPowerUpHt20[SINGLE_SKU_FILL_TABLE_HT20_LENGTH_V1];
	CHAR cPowerUpHt40[SINGLE_SKU_FILL_TABLE_HT40_LENGTH_V1];
	CHAR cPowerUpVht20[SINGLE_SKU_FILL_TABLE_VHT20_LENGTH_V1];
	CHAR cPowerUpVht40[SINGLE_SKU_FILL_TABLE_VHT40_LENGTH_V1];
	CHAR cPowerUpVht80[SINGLE_SKU_FILL_TABLE_VHT80_LENGTH_V1];
	CHAR cPowerUpVht160[SINGLE_SKU_FILL_TABLE_VHT160_LENGTH_V1];
	CHAR cPowerUpRU26[SINGLE_SKU_FILL_TABLE_RU26_LENGTH_V1];
	CHAR cPowerUpRU52[SINGLE_SKU_FILL_TABLE_RU52_LENGTH_V1];
	CHAR cPowerUpRU106[SINGLE_SKU_FILL_TABLE_RU106_LENGTH_V1];
	CHAR cPowerUpRU242[SINGLE_SKU_FILL_TABLE_RU242_LENGTH_V1];
	CHAR cPowerUpRU484[SINGLE_SKU_FILL_TABLE_RU484_LENGTH_V1];
	CHAR cPowerUpRU996[SINGLE_SKU_FILL_TABLE_RU996_LENGTH_V1];
	CHAR cPowerUpRU996X2[SINGLE_SKU_FILL_TABLE_RU996X2_LENGTH_V1];
} POWER_BOOST_PARA_V1, *PPOWER_BOOST_PARA_V1;
#endif /* TX_POWER_CONTROL_SUPPORT */

/*******************************************************************************
 *	GLOBAL VARIABLES
 ******************************************************************************/


/*******************************************************************************
 *	FUNCTION PROTOTYPES
 ******************************************************************************/
INT32 MtCmdPwrLimitTblUpdate(struct _RTMP_ADAPTER *pAd, UINT8 u1BandIdx, UINT8 u1Type, UINT8 u1ChannelBand, UINT8 u1ControlChannel, UINT8 u1CentralChannel);
#ifdef TX_POWER_CONTROL_SUPPORT
INT32 MtCmdTxPwrUpCtrl(struct _RTMP_ADAPTER *pAd, INT8 ucBandIdx,
		CHAR cPwrUpCat, CHAR cPwrUpValue[POWER_UP_CATEGORY_RATE_NUM]);
#endif /* TX_POWER_CONTROL_SUPPORT */

#endif /*__TXPWR_H__*/
