/*this file include some function to test 1905 deamon*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <errno.h>
#include <assert.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/ipc.h>
#include <sys/types.h>
#include <sys/sem.h>
#include <stddef.h>
#include <unistd.h>
#include "p1905_managerd.h"
#include "cmdu.h"
#include "cmdu_tlv.h"
#include "cmdu_message.h"
#include "multi_ap.h"
#include "debug.h"

extern int _1905_read_dev_send_1905(struct p1905_managerd_ctx* ctx,
	char* name, unsigned char *almac, unsigned short* _type,
	unsigned short *tlv_len, unsigned char *pay_load);


#define WAPP_SERVER_NAME    "wapp_server"

extern unsigned char p1905_multicast_address[];
extern unsigned char dev_send_1905_buf[];


int makeAddr(const char *name, struct sockaddr_un *pAddr, socklen_t *pSockLen)
{
    int nameLen = strlen(name);
    if (nameLen >= (int) sizeof(pAddr->sun_path) -1)  /* too long? */
        return -1;
    pAddr->sun_path[0] = '\0';  /* abstract namespace */
    strcpy(pAddr->sun_path+1, name);
    pAddr->sun_family = AF_UNIX;
    *pSockLen = 1 + nameLen + offsetof(struct sockaddr_un, sun_path);
    return 0;
}

struct wapp_usr_intf_ctrl* wapp_usr_intf_init(struct p1905_managerd_ctx *ctx)
{
	if (ctx->role == CONTROLLER)
		return wapp_usr_intf_ctrl_open("1905_client_controller", "1905_client_controller");
	else
		return wapp_usr_intf_ctrl_open("1905_client_agent", "1905_client_agent");
}


void wapp_usr_intf_deinit(struct p1905_managerd_ctx *ctx)
{
	wapp_usr_intf_ctrl_close(ctx->wapp_ctrl);
}

int wapp_usr_intf_recv(struct p1905_managerd_ctx *ctx, char *buf, size_t len)
{

	int ret = 0;
	ret = wapp_usr_intf_ctrl_recv(ctx->wapp_ctrl, buf, &len);
	if(ret == 0)
		ret = len;
	return ret;

}

/*find interface number to which message with unicast address send*/
int wapp_find_interface_num(struct p1905_managerd_ctx *ctx, unsigned char *almac)
{
	struct p1905_neighbor_info* dev_info = NULL;
	int i = 0;
	unsigned char found = 0;

	for(i = 0; i < ctx->itf_number; i++) {
		if(!LIST_EMPTY(&(ctx->p1905_neighbor_dev[i].p1905nbr_head))) {
			LIST_FOREACH(dev_info, &(ctx->p1905_neighbor_dev[i].p1905nbr_head), p1905nbr_entry)
			{
			   if(!memcmp(dev_info->al_mac_addr, almac, ETH_ALEN)) {
					found = 1;
					break;
			   }
			}
			if(found == 1)
				break;
		}
	}
	if (i < ctx->itf_number) {
		debug(DEBUG_TRACE, "send 1905 cmdu by interface(%s)\n", ctx->itf[i].if_name);
	} else {
		debug(DEBUG_TRACE, "send 1905 cmdu by br\n");
	}

	return i;
}

int wapp_usr_intf_send_command(struct p1905_managerd_ctx *ctx, char *buffer_send, int length)
{

	return wapp_usr_intf_ctrl_request(ctx->wapp_ctrl, buffer_send, length);
}

int wapp_wait_parse_spec_event(struct p1905_managerd_ctx* ctx, char* buf, size_t len, unsigned short event_type, long sec, long usec)
{
	struct timeval tv;
	int ret = 0;

	tv.tv_sec = 2;
	tv.tv_usec = 0;
	while(1)
	{
		len = MAX_PKT_LEN;
		ret = wapp_usr_intf_ctrl_pending(ctx->wapp_ctrl, &tv);
		if(ret == 1)
		{
			if(wapp_usr_intf_ctrl_recv(ctx->wapp_ctrl, buf, &len) < 0)
			{
				debug(DEBUG_ERROR, "wapp_usr_intf_ctrl_recv fail\n");
			    return wapp_utils_error;
			}
			else
			{
				if (map_event_handler(ctx, buf, len, event_type)!= -1)
				{
					return len;
				}
			}
		}
		else
		{
			debug(DEBUG_ERROR, "wait for event(0x%04x) timeout\n", event_type);
			return wapp_utils_success;
		}
	}
}


