/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2011, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	wapp_ctrl.c

	Abstract:

	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stddef.h>
#include "1905_ctrl.h"

int makeAddr(const char *name, struct sockaddr_un *pAddr, socklen_t *pSockLen)
{
    int nameLen = strlen(name);
    if (nameLen >= (int) sizeof(pAddr->sun_path) -1)  /* too long? */
        return -1;
    pAddr->sun_path[0] = '\0';  /* abstract namespace */
    strcpy(pAddr->sun_path+1, name);
    pAddr->sun_family = AF_UNIX;
    *pSockLen = 1 + nameLen + offsetof(struct sockaddr_un, sun_path);
    return 0;
}

struct _1905_ctrl *_1905_ctrl_open(const char *ctrl_path)
{
	struct _1905_ctrl *ctrl = NULL;
	socklen_t socklen;
	int status = 0;

	ctrl = malloc(sizeof(*ctrl));
	if (!ctrl) {
		printf("memory is not available\n");
		return NULL;
	}
	memset(ctrl, 0, sizeof(*ctrl));

	ctrl->s = socket(AF_UNIX, SOCK_STREAM, 0);
	if (ctrl->s < 0) {
		printf("create socket for ctrl interface fail\n");
		goto error;
	}


	makeAddr("/tmp/1905ctrl_cli", &ctrl->local, &socklen);
	if (bind(ctrl->s, (struct sockaddr *)&ctrl->local, socklen) < 0) {
		printf("bind %s error(%s)", "/tmp/1905ctrl_cli", strerror(errno));
		close(ctrl->s);
		goto error;
	}

	makeAddr(ctrl_path, &ctrl->dest, &socklen);
	status = connect(ctrl->s, (struct sockaddr *)&ctrl->dest, socklen);
	if (status < 0) {
		printf("connect %s error(%s)", ctrl_path, strerror(errno));
		close(ctrl->s);
		goto error;
	}

	return ctrl;

error:
	free(ctrl);
	return NULL;
}

void _1905_ctrl_close(struct _1905_ctrl *ctrl)
{
	close(ctrl->s);
	free(ctrl);
}

int _1905_cli_command(struct _1905_ctrl *ctrl, const char *cmd, size_t cmd_len)
{
	if (send(ctrl->s, cmd, cmd_len, 0) < 0) {
		printf("send command to 1905 ctrl socket fail\n");
		return -1;
	}

	return 0;
}

