/*
 */
#ifndef TOPOLOGY_H
#define TOPOLOGY_H
#include "list.h"
#include "p1905_managerd.h"

#define UNCONFIGURED 0x00
#define CONFIGURED_2G 0x01
#define CONFIGURED_5G 0x02

typedef void (*topology_tree_cb_func)(void *context, void* parent_leaf, void *current_leaf, void *data);


struct leaf {
	struct dl_list entry;
	unsigned char al_mac[ETH_ALEN];
	unsigned char band_cap;
	unsigned char config_status;
	unsigned char renew_send_round;
	struct os_time create_time;
	/*maybe add the local interface mac to distinguish the backhaul link change in the same device*/
	struct dl_list children;
};

struct topology_response_db *lookup_tprdb_by_almac(struct p1905_managerd_ctx *ctx, unsigned char *al_mac);
int create_topology_tree(struct p1905_managerd_ctx* ctx);
int update_topology_tree(struct p1905_managerd_ctx* ctx);
int clear_topology_tree(struct p1905_managerd_ctx* ctx);
int trace_topology_tree_cb(struct p1905_managerd_ctx* ctx, struct leaf *current_leaf, topology_tree_cb_func cb, void *data);
int topology_tree_travel_preorder(struct p1905_managerd_ctx* ctx, struct leaf *current_leaf);

#endif
