/*
 * cleopatre/application/p1905_managerd/inc/cmdu_tlv_parse.h
 *
 * (C) Copyright 2013 MSsar Semiconductor, Inc.
 */
#ifndef CMDU_TLV_PARSE_H
#define CMDU_TLV_PARSE_H

#include "p1905_managerd.h"
#include "cmdu_tlv.h"

struct vs_value {
	unsigned char discovery;
	unsigned char itf_mac[ETH_ALEN];
	unsigned char neth_almac[ETH_ALEN];
};

int get_cmdu_tlv_length(unsigned char *buf);
int parse_al_mac_addr_type_tlv(unsigned char *buf, unsigned char *al_mac);
int parse_mac_addr_type_tlv(unsigned char *buf,unsigned char *mac);
int parse_vs_tlv(unsigned char *buf, struct vs_value *vs_info);
int parse_device_info_type_tlv(struct p1905_managerd_ctx *ctx, unsigned char *buf,struct list_head_devinfo *devinfo_head);
int parse_bridge_capability_type_tlv(unsigned char *buf,struct list_head_brcap *brcap_head);
int parse_p1905_neighbor_device_type_tlv(unsigned char *buf,
    struct list_head_devinfo *devinfo_head);
int parse_non_p1905_neighbor_device_type_tlv(unsigned char *buf,
    struct list_head_devinfo *devinfo_head);
int parse_vendor_specific_type_tlv(unsigned char *buf,struct p1905_vs_info *vs_info);
int parse_supported_role_tlv(unsigned char *buf);
int parse_supported_freq_band_tlv(unsigned char *buf, unsigned char *band);
int parse_wsc_tlv(unsigned char *buf, struct p1905_managerd_ctx *ctx);
int parse_link_metric_query_type_tlv(unsigned char *buf,
    unsigned char *target, unsigned char *type);
int parse_push_button_event_notification_tlv(unsigned char *buf, iee802_11_info *wifi_info);

int parse_search_role_tlv(unsigned char *buf);
int parse_auto_config_freq_band_tlv(unsigned char *buf, unsigned char *band);


#endif /*CMDU_TLV_PARSE_H*/
