/*
 * cleopatre/application/p1905_managerd/inc/cmdu_fragment.h
 *
 * (C) Copyright 2013 MSsar Semiconductor, Inc.
 *
 */
#ifndef CMDU_RETRY_MESSAGE_H
#define CMDU_RETRY_MESSAGE_H

#include <time.h>
#include <sys/queue.h>
#include "p1905_managerd.h"

#define RETRY_ELAPSE_TIME 3
#define RETRY_CNT 3

/*data structure of RX fragment queue*/
struct retry_list
{
	unsigned char almac[ETH_ALEN];
    unsigned short mid;
	unsigned short mtype;
	unsigned char retry_cnt;
	int ifid;
    unsigned char  *data;
    unsigned short data_len;
    LIST_ENTRY(retry_list) retry_entry;
};

void init_retry_queue();
unsigned char exist_in_retry_message_list(unsigned short mtype);
void insert_retry_message_queue(unsigned char *almac, unsigned short mid,
	unsigned short mtype, unsigned char retry_cnt, int ifidx,
	unsigned char *data, unsigned short length);
void resend_message(struct p1905_managerd_ctx *ctx, struct retry_list *list);
void handle_retry_message_queue(struct p1905_managerd_ctx *ctx);
char * get_retry_mtype_str(unsigned short mtype);
void delete_retry_message_queue(unsigned char *almac, unsigned short mid,
	unsigned int ifidx);
void uninit_retry_queue();



#endif /* CMDU_FRAGMENT_H */
